Option Explicit
'######################################################################
'#                                                                    #
'#   Skript berwacht lokale Aufgaben und meldet den Status an eine   #  
'#   Serverberwachung.                                               #
'# ------------------------------------------------------------------ #
'#   Entwickelt fr check_mk                                          #
'#   Idee & Umsetzung : Christopher Pope                              #
'#   Website : www.hope-this-helps.de                                 #
'#   Getestet mit den Versionen : 1.2.3i1 / 1.2.3i6 / 1.2.4b7         #
'# ------------------------------------------------------------------ #
'#   Skript in den Ordner check_mk\local kopieren und einen           #
'#   Fullscan ausfhren dannach ist das Ergebnis in WATO sichtbar     #
'#   VarInterval steuert wie oft die Tasks ber schtasks.exe          #
'#   abgefragt werden. Die geplante Aufgabe muss Errorlevel 0 liefern #
'#   ansonst wird es als Warning eingestuft. Einzige Ausnahme ist     #
'#   Errorlevel 267009 dieser bedeutet das die Aufgabe noch           #
'#   ausgefhrt wird. Aufgaben direkt von Microsoft werden            #                           
'#   ignoriert.                                                       #
'######################################################################
Dim ObjWsh  		: Set ObjWsh = CreateObject("WScript.Shell")
Dim ObjFso  		: Set ObjFso = CreateObject("Scripting.FileSystemObject")
Dim VarScrPat		: VarScrPat = Left(WScript.ScriptFullName, InStrRev(WScript.ScriptFullName, "\"))
Dim VarFolder		: VarFolder = Replace(WScript.ScriptName,".vbs","")
Dim VarRFile		: VarRFile = VarScrPat & VarFolder & "\" & VarFolder & ".tsk"
Dim VarOutFile		: VarOutFile = VarScrPat & VarFolder & "\" & VarFolder & ".log"
Dim VarInterval		: VarInterval = 4 ' wird in Stunden angeben
Dim CntTask			: CntTask = 0
Dim ObjRFile,ObjOutFile,ts
Dim FuncLR,NewCheck,VarStatus,StrOutput
StrOutput = ""
NewCheck = false
' ---------------------------------------------------------------------

Check_Temp_Folder
Check_Last_Run

If NewCheck = True Then
	Get_Scheduling_Tasks
End If

Check_Scheduling_Tasks

Set ObjOutFile = objFSO.CreateTextFile(VarOutFile)
    ObjOutFile.WriteLine StrOutput
    ObjOutFile.Close
    
WScript.Echo StrOutput

WScript.Quit (0)


' ---------------------------------------------------------------------
Function Get_Scheduling_Tasks
	ObjWsh.Run "%comspec% /C schtasks.exe /QUERY /V /FO CSV >" & Chr(34) & VarRFile & Chr(34),False,true
End Function
' ----------
Function Check_Last_Run
	If ObjFso.FileExists(VarRFile) = True Then
		FuncLR = ObjFso.GetFile(VarRFile).DateLastModified
		If DateDiff("h",FuncLR,Now) < VarInterval Then
			NewCheck = False
		Else
			NewCheck = True
		End If
	Else
		NewCheck = True
	End If
End Function
' ----------
Function Check_Temp_Folder
	If ObjFso.FolderExists(VarScrPat & VarFolder) = False Then
		ObjFso.CreateFolder VarScrPat & VarFolder
	End If
End Function
' ----------
Function Check_Scheduling_Tasks
	If ObjFso.FileExists(VarRFile) then
		Dim TempReadLine,TempArray
		Set ObjRFile = ObjFso.OpenTextFile(VarRFile)
		Do Until ObjRFile.AtEndOfStream
			TempReadLine = Trim(ObjRFile.ReadLine)
			TempArray = Split(TempReadLine,Chr(34) & "," & Chr(34))
			If Not CleanUp(TempArray(1)) = "Aufgabenname" And _
			   InStr(CleanUp(TempArray(3)),LCase("Deaktiviert")) = 0 And _
			   Not Left(CleanUp(TempArray(1)),Len("\Microsoft\Windows")) = "\Microsoft\Windows" Then
					' ---- Output fr Check MK
					' 267009 = Aufgabe wird gerade ausgefhrt
					If TempArray(6) = "0" Or TempArray(6) = "267009" Then
						VarStatus = "0"
					Else
						VarStatus = "1"
					End If
					
					WriteOutput VarStatus & vbTab _
					          & "TASK_" & CleanUpName(CleanUp(TempArray(1))) & vbTab _
					          & "-" & vbTab _
					          & Replace(CleanUp(TempArray(1)),"\","") & "  SKRIPT : " & TempArray(8) & " ERRORLEVEL : " & TempArray(6)
					CntTask = CntTask + 1
				End If
		Loop
	Else
		Get_Scheduling_Tasks
	End If
End Function
' ----------
Function CleanUp(Wert)
	Dim Temp
	Temp = Replace(Wert,Chr(34),"")
	Temp = Replace(Temp,"","")
	Temp = Replace(Temp,"","")
	Temp = Replace(Temp,Chr(129),"")
	Temp = Replace(Temp,"(","")
	Temp = Replace(Temp,")","")
	CleanUp = Temp
End Function
' ----------
Function CleanUpName(Wert)
	Dim Temp1
	Temp1 = Replace(Wert," ","_")
	Temp1 = Replace(Temp1,"\","")
	CleanUpName = Temp1
End Function
' ----------
' ---------------------- OUTPUT SCHREIBEN
Function WriteOutput(StrInput)
	If Len(StrInput) <> 0 Then
		StrOutput = StrOutput & vbCrLf & StrInput
	Else
		StrOutput = StrInput
	End If
End Function